<?php

include '../core.php';
include '../system.inc.php';


// Notification du reclamation retard
$subject = "AVIS DE NOTIFICATION DES TICKETS EN RETARD";
$ccList = "";
$attachments = "";

$resutats = $dba->getReclamationRetardSendMail();
echo "Nombre total de resultat :". count($resutats);

// Vérifier si des réclamations ont été trouvées
if (empty($resutats)) {
    echo "Aucune réclamation en retard trouvée.";
}


    // Construire le contenu HTML
    $htmlContent = '
    <html>
    <head>
    <style>
        table { width: 100%; border-collapse: collapse;font-family:Century Gothic, sans-serif; }
        th, td { border: 1px solid #ddd; padding: 8px; }
        th { background-color: #f2f2f2; text-align: left;font-family:Century Gothic, sans-serif; }
        p{font-family:Century Gothic, sans-serif;}
    </style>
    </head>
    <body>
    <p>Bonjour, équipe MUGEFCI</p>
    <p>Veuillez trouver ci-dessous la liste des réclamations en retard :</p>
    <table>
        <thead>
            <tr>
                <th>Date de création</th>
                <th>Numéro de ticket</th>
                <th>Matricule</th>
                <th>Agent</th>
                <th>Nom et prenoms du requérant</th>
                <th> Motif d appels </th> 
                <th> Temps normal de traitement </th>          
                <th> Date expiration </th>
                <th>Temps de retard</th>
                <th>Statut</th>
            </tr>
        </thead>
        <tbody>';

    foreach ($resutats as $resutat) {
        $slaDuration = convertSecondsToMJDHMS($resutat['sla_duration_to_s']);
        $RetardDuration = convertSecondsToMJDHMS($resutat['delay_n']);
       // echo "Le numero de ticket est : ".$resutat['ticket_number_v'];

        $htmlContent .= '
        <tr>
            <td>' . htmlspecialchars($resutat['periode']) . '</td>
            <td>' . htmlspecialchars($resutat['ticket_number_v']) . '</td>
             <td>' . htmlspecialchars($resutat['matricule']) . '</td>
            <td>' . htmlspecialchars($resutat['agent_name']) . '</td>
            <td>' . htmlspecialchars($resutat['last_name_v']) . '</td>
            <td>' . htmlspecialchars($resutat['motif_name_v']) . '</td>
            <td>' . htmlspecialchars($slaDuration) . '</td>
            <td>' . htmlspecialchars($resutat['expire_at']) . '</td>
            <td>' . htmlspecialchars($RetardDuration) . '</td>
            <td>' . htmlspecialchars($resutat['status_name']) . '</td>
            
        </tr>';
    }

    $htmlContent .= '
        </tbody>
    </table>
    <p>Cordialement,</p>
    <p>Votre équipe de support SVAM</p>
    </body>
    </html>';

     $dba->SCCUploadMailNotification("reclamation@mugef-ci.com", $ccList, $subject,addslashes($htmlContent), $attachments);
    echo $htmlContent;
      


//CONVERTIR S EN MOIS JOUR HEUR MIN S
function convertSecondsToMJDHMS($value) {
    $months = floor($value / (30 * 24 * 3600));
    $restantAPresMonths = $value % (30 * 24 * 3600);

    $days = floor($restantAPresMonths / (24 * 3600));
    $RestantApresDays = $restantAPresMonths % (24 * 3600);

    $hours = floor($RestantApresDays / 3600);
    $RestantApresHours = $RestantApresDays % 3600;

    $minutes = floor($RestantApresHours / 60);
    $seconds = $RestantApresHours % 60;

    $result = '';
    if ($months > 0) {
        $result .= $months . 'Mois ';
    }
    if ($days > 0) {
        $result .= $days . 'J ';
    }
    if ($hours > 0) {
        $result .= $hours . 'H ';
    }
    if ($minutes > 0) {
        $result .= $minutes . 'Min ';
    }
    if ($seconds > 0 || ($months == 0 && $days == 0 && $hours == 0 && $minutes == 0)) {
        $result .= $seconds . 'S'; 
    }

    return trim($result);
}