<?php

session_start();
if (isset($_SESSION['basedir'])) {
    include($_SESSION['basedir'] . "core.php");
} else {
    die("Erreur : 'basedir' n'est pas défini dans la session.");
}


// Vérifier si 'basedir' est défini dans la session
if (isset($_SESSION['basedir']) && !empty($_SESSION['basedir'])) {
    $basedir = rtrim($_SESSION['basedir'], '/') . '/';
    include($basedir . 'core.php');
} else {
    die("Erreur : 'basedir' n'est pas défini dans la session.");
}

// Vérifier si la classe svaTool existe avant de l'instancier
if (class_exists('svaTool')) {
    $svaTool = new svaTool();
} else {
    die("Erreur : La classe 'svaTool' est introuvable.");
}

// Vérifier si l'objet $dba est défini et possède la méthode getReclamationOutSla
if (!isset($dba) || !method_exists($dba, 'getReclamationOutSla')) {
    die("Erreur : L'objet 'dba' ou la méthode 'getReclamationOutSla' est introuvable.");
}

// Définir le fuseau horaire par défaut
date_default_timezone_set('Africa/Abidjan');

// Obtenir la date actuelle
$currentDate = date('Y-m-d');

// Définir les plages horaires pour le jour actuel
$startDateTime = $currentDate . ' 00:00:00';
$endDateTime = $currentDate . ' 23:59:59';
$granularity = '%d/%m/%Y';
$status = -2;
$maxElement = 5000;

// Récupérer les réclamations en retard
$resutats = $dba->getReclamationOutSla($startDateTime, $endDateTime, $granularity, $status, $maxElement);

// Vérifier si des réclamations ont été trouvées
if (empty($resutats)) {
    echo "Aucune réclamation en retard trouvée.";
    exit;
}

// Construire le contenu HTML de l'e-mail
$htmlContent = '
<html>
<head>
    <style>
        table { width: 100%; border-collapse: collapse; }
        th, td { border: 1px solid #ddd; padding: 8px; }
        th { background-color: #f2f2f2; text-align: left; }
    </style>
</head>
<body>
    <p>Bonjour, équipe MUGEFCI</p>
    <p>Veuillez trouver ci-dessous la liste des réclamations en retard :</p>
    <table>
        <thead>
            <tr>
                <th>Date de création</th>
                <th>Numéro de ticket</th>
                <th>Nom</th>
                <th>Durée SLA (secondes)</th>
                <th>Durée de traitement (secondes)</th>
                <th>Statut</th>
            </tr>
        </thead>
        <tbody>';

foreach ($resutats as $resutat) {
    $htmlContent .= '
        <tr>
            <td>' . htmlspecialchars($resutat['periode']) . '</td>
            <td>' . htmlspecialchars($resutat['ticket_number_v']) . '</td>
            <td>' . htmlspecialchars($resutat['last_name_v']) . '</td>
            <td>' . htmlspecialchars($resutat['sla_duration_to_s']) . '</td>
            <td>' . htmlspecialchars($resutat['traitement_duration']) . '</td>
            <td>' . htmlspecialchars($resutat['statut_retard']) . '</td>
        </tr>';
}

$htmlContent .= '
        </tbody>
    </table>
    <p>Cordialement,</p>
    <p>Votre équipe de support SVAM</p>
</body>
</html>';

// Définir les paramètres de l'e-mail
$subject = "AVIS DE NOTIFICATION DES TICKETS EN RETARD";
$ccList = "";
$attachments = "";

// Vérifier si la fonction SCCUploadMailNotification existe avant de l'appeler
if (function_exists([$dba, 'SCCUploadMailNotification'])) {
    if ($dba->SCCUploadMailNotification("reclamation@mugef-ci.com", $ccList, $subject, $htmlContent, $attachments)) {
        echo "L'e-mail a été envoyé avec succès.";
    } else {
        echo "L'envoi de l'e-mail a échoué.";
    }
} else {
    die("Erreur : La fonction 'SCCUploadMailNotification' est introuvable.");
}

?>
