<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Class
 *
 * @author svam
 */
class MMGManagement {

    public $restartUri = "http://localhost:14000/restart?password=svam";
    public $adminUri = "http://localhost:14000/status.xml?password=svam";
    public $mmgSmppFile = "/opt/svam/binaries/ssm/config/mmg_smpp.cfg";
    public $tool;
    public $dba;

    public function __construct($dba) {

        $this->tool = new svaTool();
        $this->dba = $dba;
    }

    public function restartGateway() {

        $out = $this->tool->getUrl($this->restartUri);


        return 0;
    }

    public function getAdminData() {

        $out = $this->tool->getUrl($this->adminUri);


        return $out;
    }

    public function refreshSmppList() {

        $dbres = $this->dba->getSmsc(false, 0, 0);
        $smppData = "";
        $cnt = count($dbres);

        for ($i = 0; $i < $cnt ; $i++) {

            if ($dbres[$i]['status_n'] == 0) {

                $smppData .= $this->setSMPPDetails($dbres[$i]['host_name_v'], $dbres[$i]['port_number_n'], $dbres[$i]['receive_port_n'], $dbres[$i]['smsc_login_v'], $dbres[$i]['sms_password_v'], $dbres[$i]['system_type_v'], "", "smsc" . $dbres[$i]['smsc_id_n'], $dbres[$i]['is_transceiver_v'], $dbres[$i]['service_type_v'], $dbres[$i]['alt_charset_v'], $dbres[$i]['src_ton_n'],$dbres[$i]['src_npi_n'],$dbres[$i]['dest_ton_n'],$dbres[$i]['dest_npi_n'],$dbres[$i]['reconnect_delay_n'],$dbres[$i]['interface_version_n'] );
            }
        }

        $fp = fopen($this->mmgSmppFile, "w+");

        if ($fp) {

            fputs($fp, $smppData);

            fclose($fp);
        }

        if( $cnt > 0 ) {
            
            $this->restartGateway();
            
        }
        
    }

    function setDba($dba) {


        $this->dba = $dba;
    }

    function setSMPPDetails($hostname, $port, $rcvport, $smsclogin, $smscpassword, $systemType, $addressRaange, $smscId, $transceiver, $serviceType, $charset, $srcton, $srcnpi, $dstton, $dstnpi, $reconnect, $version  ) {
            
        $modeString = "";
        $isTransceiver = null;
        
        switch ($transceiver) {
            
            case 0 : $modeString =  "port = $port \n";  $isTransceiver = "false";  break;
            case 1 : $modeString =  "receive-port = $rcvport \n";  $isTransceiver = "false";  break;
            case 2 : $modeString =  "port = $port \n";  $isTransceiver = "true";  break;
            
            
        }
        
        
        
          $smpp = "group = smsc  \n"
                . "smsc = smpp \n"
                . "host = $hostname \n"
                .  $modeString
                . "smsc-username = \"$smsclogin\" \n"
                . "smsc-password = $smscpassword \n"
                . "system-type = \"$systemType\" \n"
                . "address-range = \"$addressRaange\" \n"
                . "smsc-id = $smscId \n"
                . "transceiver-mode = $isTransceiver \n"
                . "service-type = $serviceType \n"
                . "alt-charset = $charset \n"
                . "reconnect-delay = $reconnect \n"
                . "source-addr-ton = $srcton \n"    
                . "source-addr-npi = $srcnpi \n"
                . "dest-addr-ton = $dstton \n"
                . "dest-addr-npi = $dstnpi \n"   
                . "interface-version = $version \n"
		. "allowed-smsc-id = $smscId \n"
                . "\n"
                . "\n"

        ;


        return $smpp;
    }

}
