<?php

require_once(__DIR__ . DIRECTORY_SEPARATOR . '/phpagi-asmanager.php');

class ASM {

    public $asm;

    public function ASM() {

        $this->asm = new AGI_AsteriskManager();
    }

    public function sendRequest($command) {
        if ($this->asm->connect()) {

            $result = $this->asm->command($command);
        }

        $this->asm->disconnect();
        return $result;
    }

    public function getAgentSipUserStatus($agentNumber) {
        $status = false;
        $cmd = "sip show peers like $agentNumber";

        $peer = $this->sendRequest($cmd);

        //  print_r($peer);

        if (!strpos($peer['Output'], ':')) {
            $status = false;
        } else {
            //  echo $peer['data'];
            if (substr_count($peer['Output'], "1 online") > 0) {
                $status = true;
            }
        }
        return $status;
    }

    public function getAgentQueueMemberStatus($agentNumber) {
        $status = "Désactivé";
        $cmd = "queue show sccq";
        $peer = $this->sendRequest($cmd);
        //echo "SIP/$agentNumber (Not in use)";
        //echo $peer['data'];
        if (substr_count($peer['Output'], "SIP/$agentNumber (Not in use)") > 0) {
            $status = "Actif";
        } elseif (substr_count($peer['Output'], "SIP/$agentNumber (paused)") > 0) {

            $status = "Pause";
        }
        return $status;
    }

    public function getAgentStatusByQueue($agentNumber, $queueName) {
        $status = "Désactivé";
        $cmd = "queue show $queueName ";

      // echo $cmd;
        $peer = $this->sendRequest($cmd);
        //echo "SIP/$agentNumber (Not in use)";
        //echo $peer['data'];
        //  print_r($peer);
       
        if (substr_count($peer, "SIP/$agentNumber (ringinuse enabled) (Not in use)") > 0) {
            $status = "Actif";
        } elseif (substr_count($peer, "SIP/$agentNumber (ringinuse enabled) (paused)") > 0) {

            $status = "Pause";
        }
        return $status;
    }

    public function reloadSIPConfig() {
        $status = false;
        $cmd = "sip reload";
        $peer = $this->sendRequest($cmd);
        return $status;
    }

    public function reloadConfig() {
        $status = false;
        $cmd = "core reload";
        $peer = $this->sendRequest($cmd);
        return $status;
    }

    public function setAgentQueueMemberStatus($agentNumber, $status) {
        $cmd = "queue $status member SIP/$agentNumber";
        $peer = $this->sendRequest($cmd);
        //echo "SIP/$agentNumber (Not in use)";
        //echo $peer['data'];
        return 0;
    }

    public function exec($cmd) {
    $res ="";

        $socket = fsockopen("127.0.0.1", "5038", $errno, $errstr, 10);
        if (!$socket) {
            echo "$errstr ($errno)\n";
        } else {
     
            fputs($socket, "Action: Login\r\n");
            fputs($socket, "UserName: svam\r\n");
            fputs($socket, "Secret: svam\r\n\r\n");
            fputs($socket, "Action: Command\r\n");
            fputs($socket, "Command: $cmd\r\n");

            fputs($socket, "Action: Logoff\r\n\r\n");

            while (!feof($socket)) {

                $result = fgets($socket);

             // $result .="\n\r";
             copy($result, $res);
           

                if (stristr($result, 'Callers') == TRUE) {
                 // echo  $result;
                    exit();
                }
            }
        }
        fclose($socket);
        echo $res;
        return $res;
    }
    
    
    
    
    public function getSipUserRegistrationStatus($username) {
        $status = false;
        $cmd = "sip show registry";

        $peer = $this->sendRequest($cmd);

          print_r($peer);

        if (!strpos($peer['Output'], ':')) {
            $status = false;
        } else {
            //  echo $peer['data'];
            if (substr_count($peer['Output'], "1 online") > 0) {
                $status = true;
            }
        }
        return $status;
    }
    
    
    
    
    

}

?>